/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import jpos.JposException;

public class StatisticsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6789011810352167205L;
    private JRadioButton updateRadio;
    private JRadioButton resetRadio;
    private JRadioButton retrieveRadio;
    private Method retrieveMethod = null;
    private Method updateMethod = null;
    private Method resetMethod = null;
    private Method getCapUpdateStatistics = null;
    private Method getCapStatisticsReporting = null;
    private Boolean capUpdateStatistics = new Boolean(false);
    private Boolean capStatisticsReporting = new Boolean(false);
    private Object deviceObject;
    private JTextField argumentTF;
    private JTextArea messageWindow;

    public StatisticsDialog(Object object) throws Exception {
        this.deviceObject = object;
        Class<?> c = object.getClass();
        Method[] theMethods = c.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            if (theMethods[i].getName().equals("retrieveStatistics")) {
                this.retrieveMethod = theMethods[i];
            } else if (theMethods[i].getName().equals("updateStatistics")) {
                this.updateMethod = theMethods[i];
            } else if (theMethods[i].getName().equals("resetStatistics")) {
                this.resetMethod = theMethods[i];
            } else if (theMethods[i].getName().equals("getCapUpdateStatistics")) {
                this.getCapUpdateStatistics = theMethods[i];
            } else if (theMethods[i].getName().equals("getCapStatisticsReporting")) {
                this.getCapStatisticsReporting = theMethods[i];
            }
            ++i;
        }
        if (this.retrieveMethod == null || this.updateMethod == null || this.resetMethod == null) {
            throw new Exception("Object passed to StatisticsDialog() does not support the statistics interface.\nPerhaps the Service Object is UPOS v1.7 complient or lower.");
        }
        try {
            Object[] args = new Object[]{};
            this.capStatisticsReporting = (Boolean)this.getCapStatisticsReporting.invoke(this.deviceObject, args);
            this.capUpdateStatistics = (Boolean)this.getCapUpdateStatistics.invoke(this.deviceObject, args);
        }
        catch (InvocationTargetException e) {
            JposException je = (JposException)e.getTargetException();
            JOptionPane.showMessageDialog(null, "exception getting device caps:\n" + je.getMessage(), "Exception", 0);
        }
        catch (IllegalAccessException e) {
            JOptionPane.showMessageDialog(null, "call to a getCap function threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
        }
        this.setModal(true);
        this.setSize(500, 300);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.setContentPane(mainPanel);
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        mainPanel.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        mainPanel.add(row2);
        JPanel row3 = new JPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        mainPanel.add(row3);
        JPanel row4 = new JPanel();
        row4.setLayout(new BoxLayout(row4, 0));
        mainPanel.add(row4);
        JPanel textBox = new JPanel();
        textBox.setLayout(new BoxLayout(textBox, 1));
        row2.add(textBox);
        ButtonGroup group = new ButtonGroup();
        this.retrieveRadio = new JRadioButton("Retrieve");
        this.retrieveRadio.setEnabled(this.capStatisticsReporting);
        this.retrieveRadio.setSelected(true);
        group.add(this.retrieveRadio);
        row1.add(this.retrieveRadio);
        this.resetRadio = new JRadioButton("Reset");
        this.resetRadio.setSelected(false);
        this.resetRadio.setEnabled(this.capUpdateStatistics);
        group.add(this.resetRadio);
        row1.add(this.resetRadio);
        this.updateRadio = new JRadioButton("Update");
        this.updateRadio.setSelected(false);
        this.updateRadio.setEnabled(this.capUpdateStatistics);
        group.add(this.updateRadio);
        row1.add(this.updateRadio);
        row1.add(Box.createHorizontalStrut(150));
        JButton goButton = new JButton("Go");
        goButton.setActionCommand("Go");
        goButton.addActionListener(this);
        row1.add(goButton);
        row1.add(Box.createHorizontalStrut(5));
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("Close");
        closeButton.addActionListener(this);
        row1.add(closeButton);
        JLabel label = new JLabel("\"Argument\" is the value to be passed to the statistics methods.");
        textBox.add(label);
        label = new JLabel("Separate multiple statistics with commas.");
        textBox.add(label);
        label = new JLabel("When updating statistics, use name=value pairs.");
        textBox.add(label);
        label = new JLabel("Argument:");
        label.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        label.setEnabled(this.capUpdateStatistics);
        row3.add(label);
        this.argumentTF = new JTextField();
        this.argumentTF.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.argumentTF.setPreferredSize(new Dimension(200, 25));
        this.argumentTF.setEnabled(this.capStatisticsReporting);
        row3.add(this.argumentTF);
        row3.add(Box.createHorizontalStrut(150));
        this.messageWindow = new JTextArea();
        this.messageWindow.setBorder(new BevelBorder(1));
        JScrollPane scrollPane = new JScrollPane(this.messageWindow);
        scrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        row4.add(scrollPane);
        if (!this.capStatisticsReporting.booleanValue()) {
            this.messageWindow.setText("capStatisticsReporting is false for this device");
            goButton.setEnabled(false);
        }
        this.setTitle("Device Statistics");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Close")) {
            this.setVisible(false);
        } else if (ae.getActionCommand().equals("Go")) {
            JposException je;
            Object[] args;
            if (this.updateRadio.isSelected()) {
                try {
                    args = new Object[]{this.argumentTF.getText()};
                    this.updateMethod.invoke(this.deviceObject, args);
                }
                catch (InvocationTargetException e) {
                    je = (JposException)e.getTargetException();
                    JOptionPane.showMessageDialog(null, "updateStatistics threw an exception:\n" + je.getMessage(), "Exception", 0);
                }
                catch (IllegalAccessException e) {
                    JOptionPane.showMessageDialog(null, "call to updateStatistics threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
                }
            }
            if (this.resetRadio.isSelected()) {
                try {
                    args = new Object[]{this.argumentTF.getText()};
                    this.resetMethod.invoke(this.deviceObject, args);
                }
                catch (InvocationTargetException e) {
                    je = (JposException)e.getTargetException();
                    JOptionPane.showMessageDialog(null, "resetStatistics threw an exception:\n" + je.getMessage(), "Exception", 0);
                }
                catch (IllegalAccessException e) {
                    JOptionPane.showMessageDialog(null, "call to resetStatistics threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
                }
            }
            if (this.retrieveRadio.isSelected()) {
                try {
                    args = new Object[1];
                    String[] stats = new String[]{this.argumentTF.getText()};
                    args[0] = stats;
                    this.retrieveMethod.invoke(this.deviceObject, args);
                    this.messageWindow.setText(stats[0]);
                }
                catch (InvocationTargetException e) {
                    je = (JposException)e.getTargetException();
                    JOptionPane.showMessageDialog(null, "retrieveStatistics threw an exception:\n" + je.getMessage(), "Exception", 0);
                }
                catch (IllegalAccessException e) {
                    JOptionPane.showMessageDialog(null, "call to retrieveStatistics threw an IllegalAccessException:\n" + e.getMessage(), "Exception", 0);
                }
            }
        }
    }
}

