/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import jpos.events.ErrorEvent;

public class ErrorPromptDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4332027575682829695L;
    private ErrorEvent errorEvent;
    private JRadioButton clearRadio;
    private JRadioButton retryRadio;
    private JRadioButton continueRadio;
    private JTextArea messageWindow;

    public ErrorPromptDlg(ErrorEvent event, String msg) {
        this.errorEvent = event;
        this.setModal(true);
        this.setSize(500, 350);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.setContentPane(mainPanel);
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        mainPanel.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        mainPanel.add(row2);
        JPanel row3 = new JPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        mainPanel.add(row3);
        JPanel row4 = new JPanel();
        row4.setLayout(new BoxLayout(row4, 0));
        mainPanel.add(row4);
        JPanel row5 = new JPanel();
        row5.setLayout(new BoxLayout(row5, 0));
        mainPanel.add(row5);
        this.messageWindow = new JTextArea();
        this.messageWindow.setBorder(new BevelBorder(1));
        JScrollPane scrollPane = new JScrollPane(this.messageWindow);
        scrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, 100));
        row1.add(scrollPane);
        this.messageWindow.setText(msg);
        JLabel label = new JLabel();
        String text = "Error Locus: ";
        switch (this.errorEvent.getErrorLocus()) {
            case 2: {
                text = String.valueOf(text) + "Input";
                break;
            }
            case 3: {
                text = String.valueOf(text) + "Input with Data";
                break;
            }
            case 1: {
                text = String.valueOf(text) + "Output";
                break;
            }
            default: {
                text = String.valueOf(text) + "Unknown.. This is an error with the SO!!!";
            }
        }
        label.setText(text);
        row2.add(label);
        ButtonGroup group = new ButtonGroup();
        this.retryRadio = new JRadioButton("Retry");
        this.retryRadio.setSelected(this.errorEvent.getErrorResponse() == 11);
        group.add(this.retryRadio);
        row3.add(this.retryRadio);
        this.clearRadio = new JRadioButton("Clear");
        this.clearRadio.setSelected(this.errorEvent.getErrorResponse() == 12);
        group.add(this.clearRadio);
        row3.add(this.clearRadio);
        this.continueRadio = new JRadioButton("Continue Input");
        this.continueRadio.setSelected(this.errorEvent.getErrorResponse() == 13);
        group.add(this.continueRadio);
        row3.add(this.continueRadio);
        JButton closeButton = new JButton("OK");
        closeButton.setActionCommand("OK");
        closeButton.addActionListener(this);
        row4.add(closeButton);
        row5.add(Box.createVerticalStrut(10));
        this.setTitle("Error Event");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int resp = 0;
        if (ae.getActionCommand().equals("OK")) {
            if (this.clearRadio.isSelected()) {
                resp = 12;
            } else if (this.retryRadio.isSelected()) {
                resp = 11;
            } else if (this.continueRadio.isSelected()) {
                resp = 13;
            }
            this.errorEvent.setErrorResponse(resp);
            this.setVisible(false);
        }
    }
}

