/*
 * Decompiled with CFR 0.152.
 */
package com.jpos.POStest;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class DrawPanel
extends JPanel
implements MouseMotionListener {
    private static final long serialVersionUID = -7018107363017640128L;
    int x1;
    int y1;
    int x2;
    int y2;
    int[] xArray;
    int[] yArray;
    int i = 0;
    int j;
    int k;
    int minx = 65535;
    int miny = 65535;
    int maxx = 0;
    int maxy = 0;
    Dimension preferredSize = new Dimension(320, 240);

    public DrawPanel() {
        this.setBackground(new Color(0.98f, 0.97f, 0.85f));
        this.addMouseMotionListener(this);
        this.clear();
    }

    public void clear() {
        this.i = 0;
        this.xArray = new int[1000];
        this.yArray = new int[1000];
        this.xArray[this.i] = 65535;
        this.yArray[this.i] = 65535;
        ++this.i;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.j = this.i - 1;
        if (this.xArray[this.j] != 65535 || this.yArray[this.j] != 65535) {
            this.xArray[this.i] = 65535;
            this.yArray[this.i] = 65535;
            ++this.i;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.xArray[this.i] = e.getX();
        this.yArray[this.i] = e.getY();
        ++this.i;
        if (this.i == 1000) {
            this.i = 1;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.k = 1;
        while (this.k < this.i) {
            this.x1 = this.xArray[this.k - 1];
            this.y1 = this.yArray[this.k - 1];
            this.x2 = this.xArray[this.k];
            this.y2 = this.yArray[this.k];
            if (!(this.x1 == 65535 && this.y1 == 65535 || this.x2 == 65535 && this.y2 == 65535)) {
                this.x1 -= this.minx;
                this.y1 -= this.miny;
                this.x2 -= this.minx;
                this.y2 -= this.miny;
                g.drawLine(this.x1, this.y1, this.x2, this.y2);
            }
            ++this.k;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Point[] getPoints() {
        Point[] points = new Point[this.i - 1];
        this.j = 0;
        while (this.j < this.i - 1) {
            points[this.j] = new Point(this.xArray[this.j + 1], this.yArray[this.j + 1]);
            ++this.j;
        }
        return points;
    }

    public void setPoints(Point[] points) {
        this.clear();
        this.j = 0;
        while (this.j < points.length) {
            Point p = points[this.j];
            if (p != null) {
                this.xArray[this.i] = new Double(p.getX()).intValue();
                this.yArray[this.i] = new Double(p.getY()).intValue();
                if (p.x < this.minx) {
                    this.minx = p.x;
                }
                if (p.y < this.miny) {
                    this.miny = p.y;
                }
                if (p.x != 65535 && p.x > this.maxx) {
                    this.maxx = p.x;
                }
                if (p.x != 65535 && p.y > this.maxy) {
                    this.maxy = p.y;
                }
                ++this.i;
            }
            ++this.j;
        }
    }
}

