/*
 * Decompiled with CFR 0.152.
 */
package com.xl.util;

import com.xl.util.DefaultProperties;
import com.xl.util.TracerOutput;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;

public class Logger {
    private static Logger instance = null;
    protected static Boolean defaultDebugOn = false;
    protected static LogLevel defaultLogLevel = LogLevel.Info;
    protected static PrintStream defaultPrintStream = System.out;
    private boolean tracerOn = defaultDebugOn;
    private LogLevel logLevel = defaultLogLevel;
    private String tracerName = "";
    private boolean appendName = true;
    private boolean isCustomTracerOutput = false;
    private TracerOutput onTracerOutput = null;
    private TracerOutput offTracerOutput = new TracerOutput(){

        public void close() {
        }

        public String getPrefix() {
            return "";
        }

        @Override
        public void print(Exception e) {
        }

        @Override
        public void println(String s) {
        }

        @Override
        public void print(String s) {
        }

        @Override
        public void flush() {
        }
    };

    static {
        DefaultProperties props = DefaultProperties.getInstance();
        defaultDebugOn = props.isPropertyDefined("com.xl.util.Logger.ON") && props.getPropertyString("com.xl.util.Logger.ON").equalsIgnoreCase("TRUE");
        try {
            if (props.isPropertyDefined("com.xl.util.Logger.logLevel")) {
                defaultLogLevel = LogLevel.valueOf(props.getPropertyString("com.xl.util.Logger.logLevel"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (props.isPropertyDefined("com.xl.util.Logger.outFile")) {
            String logFile = props.getPropertyString("com.xl.util.Logger.outFile");
            String os = System.getProperty("os.name").toUpperCase();
            if (os.contains("WINDOWS") && props.isPropertyDefined("com.xl.util.Logger.inTmpPath") && props.getPropertyString("com.xl.util.Logger.outFile") == "TRUE") {
                logFile = String.valueOf(System.getProperty("java.io.tmpdir")) + logFile;
            }
            try {
                defaultPrintStream = new PrintStream(logFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (instance == null) {
            instance = new Logger();
            if (props.isPropertyDefined("com.xl.util.Logger.logSystemPoroperties") && props.getPropertyString("com.xl.util.Logger.logSystemPoroperties").equalsIgnoreCase("TRUE")) {
                instance.logProperties();
            }
            if (props.isPropertyDefined("com.xl.util.Logger.logOptions") && props.getPropertyString("com.xl.util.Logger.logOptions").equalsIgnoreCase("TRUE")) {
                instance.logOptions();
            }
        }
    }

    protected Logger() {
        this.appendName = false;
        this.tracerName = "";
        this.onTracerOutput = new DefaultTracerOutput("", defaultPrintStream);
    }

    public Logger(String name) {
        if (name == null || name.equals("")) {
            this.appendName = false;
            this.tracerName = "";
            this.onTracerOutput = new DefaultTracerOutput("", defaultPrintStream);
        } else {
            this.appendName = true;
            this.tracerName = name;
            this.onTracerOutput = new DefaultTracerOutput("[" + name + "]", defaultPrintStream);
        }
    }

    public Logger(String name, PrintStream ps) {
        if (name == null || name.equals("")) {
            this.appendName = false;
            this.tracerName = "";
            this.onTracerOutput = new DefaultTracerOutput("", ps);
        } else {
            this.appendName = true;
            this.tracerName = name;
            this.onTracerOutput = new DefaultTracerOutput("[" + name + "]", ps);
        }
    }

    public static Logger getInstance() {
        return instance;
    }

    public void setLogLevel(LogLevel i) {
        this.logLevel = i;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void error(String s) {
        this.getTracerOutput(LogLevel.Error).println(s);
    }

    public void error(Exception e) {
        this.getTracerOutput(LogLevel.Error).print(e);
    }

    public void warn(String s) {
        this.getTracerOutput(LogLevel.Warn).println(s);
    }

    public void info(String s) {
        this.getTracerOutput(LogLevel.Info).println(s);
    }

    public void debug(String s) {
        this.getTracerOutput(LogLevel.Debug).println(s);
    }

    public void trace(String s) {
        this.getTracerOutput(LogLevel.Trace).println(s);
    }

    public void logProperties() {
        try {
            TracerOutput log = this.getTracerOutput();
            log.println("System.properties entries: ");
            int i = 0;
            Iterator<Map.Entry<Object, Object>> it = System.getProperties().entrySet().iterator();
            while (it.hasNext()) {
                String propName = it.next().toString();
                log.println("(" + i++ + ")" + "key:" + propName + "; value:" + System.getProperties().getProperty(propName));
            }
            log.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void logOptions() {
        try {
            TracerOutput log = this.getTracerOutput();
            log.println("xl.properties entries: ");
            DefaultProperties options = DefaultProperties.getInstance();
            Iterator prop = options.getProps();
            int i = 0;
            while (prop.hasNext()) {
                String propName = prop.next().toString();
                String propValue = options.getPropertyString(propName);
                log.println("(" + i++ + ")" + "key:" + propName + "; value:" + propValue);
            }
            log.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void flush() {
        this.getTracerOutput().flush();
    }

    public void setOn(boolean b) {
        this.tracerOn = b;
    }

    public boolean isOn() {
        return this.tracerOn;
    }

    public String getName() {
        return this.tracerName;
    }

    public void setAppendName(boolean b) {
        this.appendName = b;
    }

    public boolean isAppendName() {
        return this.appendName;
    }

    public static String bytes2HexString(byte[] buf, int len) {
        String hexString = "";
        int i = 0;
        while (i < len) {
            hexString = String.valueOf(hexString) + String.format(" 0x%02X", buf[i]);
            ++i;
        }
        return hexString;
    }

    protected void println(String s) {
        this.getTracerOutput(this.logLevel).println(s);
    }

    protected void println(Object obj) {
        this.getTracerOutput(this.logLevel).println(obj.toString());
    }

    protected void print(String s) {
        this.getTracerOutput(this.logLevel).print(s);
    }

    protected void print(Object obj) {
        this.getTracerOutput(this.logLevel).print(obj.toString());
    }

    protected void print(Exception e) {
        this.getTracerOutput(this.logLevel).print(e);
    }

    private TracerOutput getTracerOutput() {
        return this.isOn() ? this.onTracerOutput : this.offTracerOutput;
    }

    private TracerOutput getTracerOutput(LogLevel logLevel) {
        return this.isOn() && this.logLevel.compareTo(logLevel) > 0 ? this.onTracerOutput : this.offTracerOutput;
    }

    void setTracerOutput(TracerOutput tracerOutput) {
        this.tracerOn = true;
        this.isCustomTracerOutput = true;
        this.onTracerOutput = tracerOutput;
    }

    static /* synthetic */ void access$0(Logger logger, boolean bl) {
        logger.appendName = bl;
    }

    static /* synthetic */ boolean access$1(Logger logger) {
        return logger.appendName;
    }

    class DefaultTracerOutput
    implements TracerOutput {
        protected String prefix = "";
        protected PrintStream printStream = System.err;

        public DefaultTracerOutput() {
            this.prefix = "";
            Logger.this.appendName = false;
        }

        public DefaultTracerOutput(String s) {
            if (s == null) {
                this.prefix = "";
            } else if (s.equals("")) {
                this.prefix = "";
            } else {
                this.prefix = s;
                Logger.this.appendName = true;
            }
        }

        public DefaultTracerOutput(String s, PrintStream pStream) {
            this(s);
            this.printStream = pStream;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void close() {
            this.getPrintStream().close();
        }

        @Override
        public void println(String s) {
            this.getPrintStream().println(String.valueOf(Logger.this.appendName ? this.prefix : "") + s);
        }

        @Override
        public void print(String s) {
            this.getPrintStream().print(String.valueOf(Logger.this.appendName ? this.prefix : "") + s);
        }

        @Override
        public void print(Exception e) {
            if (Logger.this.appendName) {
                this.getPrintStream().println("<" + this.prefix + ">");
                System.err.println("<" + this.prefix + ">");
            }
            e.printStackTrace(this.getPrintStream());
            e.printStackTrace(System.err);
            if (Logger.this.appendName) {
                this.getPrintStream().println("</" + this.prefix + ">");
                System.err.println("</" + this.prefix + ">");
            }
        }

        @Override
        public void flush() {
            this.getPrintStream().flush();
        }

        protected PrintStream getPrintStream() {
            return this.printStream;
        }

        protected void setPrintStream(PrintStream pStream) {
            this.printStream = pStream;
        }
    }

    public static enum LogLevel {
        Error,
        Warn,
        Info,
        Debug,
        Trace;

    }
}

