/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.service;

import com.xl.jpos.service.LabelReceivedListener;
import com.xl.jpos.service.ScannerEventContainer;
import com.xl.jpos.service.ScannerEventDispatcher;
import com.xl.jpos.service.ScannerEventEntity;
import com.xl.jpos.service.XLBaseService;
import com.xl.jpos.service.XLException;
import com.xl.jpos.service.XLScanner;
import com.xl.jpos.service.XLScannerSymbologies;
import com.xl.util.XLBarcode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jpos.JposException;
import jpos.ScannerConst;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceInstance;
import jpos.services.EventCallbacks;

public class XLScannerService
extends XLBaseService
implements JposServiceInstance,
ScannerConst,
ScannerEventContainer,
LabelReceivedListener {
    protected static final int nDelayTimeout = 30000;
    protected ScannerEventDispatcher eventDispatcher = null;
    protected XLScanner scanner = null;
    protected boolean bAutoDisable = false;
    protected boolean bDataEventEnabled = true;
    protected boolean bDecodeData = true;
    protected byte[] aScanData = new byte[0];
    protected byte[] aScanDataLabel = new byte[0];
    protected int iScanDataType = 0;
    protected String sDecodeType = null;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$xl$jpos$service$ScannerEventEntity$EventType;

    public XLScannerService() {
        this.eventDispatcher = new ScannerEventDispatcher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (!this.bOpened) {
            this.log.error("setDataEventEnabled: (101) Service not open!");
            throw new JposException(101, "Service not open");
        }
        this.log.debug("setDataEventEnabled: " + dataEventEnabled);
        XLScannerService xLScannerService = this;
        synchronized (xLScannerService) {
            if (dataEventEnabled != this.bDataEventEnabled) {
                this.bDataEventEnabled = dataEventEnabled;
                this.eventDispatcher.dataEventEnabled = dataEventEnabled;
            }
        }
    }

    @Override
    public void ScannerEventHandler(ScannerEventEntity entity) {
        try {
            if (this.evtCallback != null) {
                switch (entity.eventType) {
                    case Data: {
                        if (entity.bDecodeData) {
                            this.iScanDataType = entity.scanType;
                            int len = entity.aScanData.length;
                            this.aScanData = new byte[len];
                            System.arraycopy(entity.aScanData, 0, this.aScanData, 0, len);
                            len = entity.aScanDataLabel.length;
                            this.aScanDataLabel = new byte[len];
                            System.arraycopy(entity.aScanDataLabel, 0, this.aScanDataLabel, 0, len);
                        } else {
                            this.iScanDataType = 0;
                            this.aScanDataLabel = new byte[0];
                            int len = entity.aScanData.length;
                            this.aScanData = new byte[len];
                            System.arraycopy(entity.aScanData, 0, this.aScanData, 0, len);
                        }
                        this.evtCallback.fireDataEvent((DataEvent)entity.jposEvent);
                        this.eventDispatcher.dataEventEnabled = true;
                        break;
                    }
                    case DirectIO: {
                        this.evtCallback.fireDirectIOEvent((DirectIOEvent)entity.jposEvent);
                        break;
                    }
                    case Error: {
                        this.evtCallback.fireErrorEvent((ErrorEvent)entity.jposEvent);
                        break;
                    }
                    case StatusUpdate: {
                        this.evtCallback.fireStatusUpdateEvent((StatusUpdateEvent)entity.jposEvent);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.error(ex);
        }
    }

    @Override
    public void onLabelReceived(byte[] rawLabelData, byte[] decodedLabelData, int nType) {
        int uposSymbType = 0;
        boolean isBCDData = false;
        this.log.debug("onLabelReceived start.");
        try {
            if (this.bDecodeData) {
                decodedLabelData = XLBarcode.justifyLabelData((int)nType, (byte[])decodedLabelData);
                if (isBCDData) {
                    XLBarcode.justifyBCDData((byte[])rawLabelData);
                    XLBarcode.justifyBCDData((byte[])decodedLabelData);
                }
                uposSymbType = XLScannerSymbologies.getUPOSSymbology(nType);
            } else if (isBCDData) {
                XLBarcode.justifyBCDData((byte[])rawLabelData);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.error(ex);
        }
        this.log.debug("Label: " + new String(decodedLabelData));
        DataEvent dataEvent = new DataEvent((Object)this, 0);
        ScannerEventEntity entity = new ScannerEventEntity((JposEvent)dataEvent, ScannerEventEntity.EventType.Data);
        entity.bDecodeData = this.bDecodeData;
        entity.aScanData = new byte[rawLabelData.length];
        System.arraycopy(rawLabelData, 0, entity.aScanData, 0, rawLabelData.length);
        if (this.bDecodeData) {
            entity.scanType = uposSymbType;
            entity.aScanDataLabel = new byte[decodedLabelData.length];
            System.arraycopy(decodedLabelData, 0, entity.aScanDataLabel, 0, decodedLabelData.length);
        } else {
            entity.scanType = 0;
            entity.aScanDataLabel = new byte[0];
        }
        this.eventDispatcher.push(entity);
        this.log.debug("onLabelReceived end.");
    }

    @Override
    public void DataReceived() {
        if (this.bAutoDisable) {
            try {
                this.setDeviceEnabled(false);
            }
            catch (JposException jposException) {
                jposException.printStackTrace();
                this.log.error((Exception)((Object)jposException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String logicalName, EventCallbacks cb) throws JposException {
        this.log.debug("XLScannerService open start: " + logicalName);
        this.category = "Scanner";
        super.open(logicalName, cb);
        this.bDecodeData = false;
        this.bFreezeEvents = false;
        this.bAutoDisable = false;
        ScannerEventDispatcher scannerEventDispatcher = this.eventDispatcher;
        synchronized (scannerEventDispatcher) {
            try {
                this.bAutoDisable = false;
                this.bDataEventEnabled = false;
                this.aScanData = new byte[0];
                this.aScanDataLabel = new byte[0];
                this.iScanDataType = 0;
                this.eventDispatcher.dataEventEnabled = this.bDataEventEnabled;
                this.eventDispatcher.freezeEvents = this.bFreezeEvents;
                this.eventDispatcher.needStopThread = false;
                this.eventDispatcher.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.log.debug("XLScannerService open end.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void claim(int lTimeout) throws JposException {
        this.log.debug("XLScannerService claim start.");
        ScannerEventDispatcher scannerEventDispatcher = this.eventDispatcher;
        synchronized (scannerEventDispatcher) {
            try {
                super.claim(lTimeout);
            }
            catch (Exception ex) {
                throw new JposException(114, ex.getMessage());
            }
        }
        this.scanner = (XLScanner)this.device;
        this.scanner.addLabelReceivedListener(this);
        this.sDecodeType = this.deviceInfo.getOption("decodeType");
        this.log.debug("XLScannerService claim end.");
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws JposException {
        this.log.debug("directIO start: command:" + command);
        String resultMsg = "";
        if (!this.bOpened) {
            this.log.error("setDeviceEnabled: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        if (!this.bClaimed) {
            this.log.error("setDeviceEnabled: (103) Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.scanner.directIO(command, data, object);
            resultMsg = "ok";
        }
        catch (XLException ex) {
            this.log.error("directIO: (114/" + ex.getErrorCode() + ")" + ex.getMessage());
            throw new JposException(114, ex.getErrorCode(), ex.getMessage());
        }
        try {
            if (object instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)object).write(resultMsg.getBytes());
            }
        }
        catch (IOException ex) {
            this.log.error("directIO: (114)" + ex.getMessage());
            throw new JposException(114, 0, ex.getMessage());
        }
    }

    @Override
    public void close() throws JposException {
        this.scanner.removeLabelReceivedListener(this);
        this.releaseEventDispatcher();
        super.close();
        this.log.debug("XLScannerService close.");
    }

    @Override
    public void release() throws JposException {
        this.scanner.removeLabelReceivedListener(this);
        this.releaseEventDispatcher();
        super.release();
        this.log.debug("XLScannerService release.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseEventDispatcher() {
        ScannerEventDispatcher scannerEventDispatcher = this.eventDispatcher;
        synchronized (scannerEventDispatcher) {
            if (!this.eventDispatcher.needStopThread) {
                this.eventDispatcher.needStopThread = true;
                this.eventDispatcher.notify();
            }
            if (this.eventDispatcher.dataEventEnabled) {
                this.eventDispatcher.dataEventEnabled = false;
            }
            this.eventDispatcher.Clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        block8: {
            this.log.debug("setDeviceEnabled start: " + deviceEnabled);
            if (!this.bOpened) {
                this.log.error("setDeviceEnabled: (101) Service not open");
                throw new JposException(101, "Service not open");
            }
            if (!this.bClaimed) {
                this.log.error("setDeviceEnabled: (103) Device not claimed");
                throw new JposException(103, "Device not claimed");
            }
            try {
                if (this.scanner == null) break block8;
                XLScanner xLScanner = this.scanner;
                synchronized (xLScanner) {
                    if (deviceEnabled != this.scanner.bEnabled) {
                        this.scanner.setEnabled(deviceEnabled);
                    }
                }
            }
            catch (Exception e) {
                this.log.error("Error enabling/disabling device: " + e.getMessage());
                throw new JposException(111, e.getMessage());
            }
        }
        super.setDeviceEnabled(deviceEnabled);
        this.log.debug("setDeviceEnabled end:" + deviceEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        if (!this.bOpened) {
            this.log.error("setFreezeEvents: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        ScannerEventDispatcher scannerEventDispatcher = this.eventDispatcher;
        synchronized (scannerEventDispatcher) {
            if (freezeEvents != this.eventDispatcher.freezeEvents) {
                this.eventDispatcher.freezeEvents = freezeEvents;
                this.eventDispatcher.notify();
            }
        }
        super.setFreezeEvents(freezeEvents);
        this.log.debug("setFreezeEvents:" + freezeEvents);
    }

    public void setAutoDisable(boolean autoDisable) throws JposException {
        this.bAutoDisable = autoDisable;
    }

    public int getDataCount() throws JposException {
        if (!this.bOpened) {
            this.log.error("getDataCount: (101) Device not open");
            throw new JposException(101, "Device not open");
        }
        return this.eventDispatcher.dataEventCount;
    }

    public byte[] getItemData() throws JposException {
        this.log.debug("getItemData");
        if (this.getState() == 1) {
            this.log.error("getItemData: (101) Device not open");
            throw new JposException(101, "Device not open");
        }
        this.log.trace("getItemData: " + new String(this.aScanData));
        this.log.debug("getItemData");
        return this.aScanData;
    }

    public void clearInput() throws JposException {
        if (this.bOpened) {
            this.log.error("clearInput: (101) Device not open");
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            this.log.error("clearInput:(103) not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.eventDispatcher.Clear();
        this.log.debug("clearInput");
    }

    public void clearInputProperties() throws JposException {
        if (this.bOpened) {
            this.log.error("clearInput: (101) Device not open");
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            this.log.error("clearInput:(103) not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.aScanData = new byte[0];
        this.aScanDataLabel = new byte[0];
        this.iScanDataType = 0;
        this.log.debug("clearInputProperties");
    }

    public void deleteInstance() throws JposException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueError(int nCode, int nExCode, int nLocus, int nResponse) {
        this.log.debug("EnqueueError start: nCode:" + nCode + "; nExCode:" + nExCode + "; nLocus:" + nLocus + "; nResponse:" + nResponse);
        if (!this.bFreezeEvents) {
            ScannerEventDispatcher scannerEventDispatcher = this.eventDispatcher;
            synchronized (scannerEventDispatcher) {
                ErrorEvent err = new ErrorEvent((Object)this, nCode, nExCode, 3, 13);
                ScannerEventEntity entity = new ScannerEventEntity((JposEvent)err, ScannerEventEntity.EventType.Error);
                this.eventDispatcher.push(entity);
            }
        }
        this.log.debug("enqueueError end.");
    }

    @Override
    public void onDeviceError(int nErrorCode) {
        block12: {
            block11: {
                boolean supressErrors;
                this.log.debug("onDeviceError start: " + nErrorCode);
                boolean bl = supressErrors = this.options.getPropertyString("com.xl.jpos.service.ScannerService.suppressErrors") == "TRUE";
                if (supressErrors) break block11;
                this.iState = 4;
                switch (nErrorCode) {
                    case -120: 
                    case -116: {
                        if (this.options.getPropertyString("com.xl.jpos.service.ScannerService.PostRemovalErrorEvents") == "TRUE") {
                            this.enqueueError(107, -116, 2, 12);
                            break;
                        }
                        break block12;
                    }
                    case -113: {
                        this.enqueueError(111, -113, 2, 12);
                        break;
                    }
                    case -105: {
                        this.enqueueError(111, -105, 2, 12);
                        break;
                    }
                    case -111: {
                        this.enqueueError(113, -111, 2, 13);
                        break;
                    }
                    case -112: {
                        this.enqueueError(113, -112, 2, 13);
                        break;
                    }
                    case -115: {
                        this.enqueueError(106, -115, 1, 13);
                        break;
                    }
                    case -114: {
                        this.enqueueError(106, -114, 1, 13);
                        break;
                    }
                    case -100: {
                        this.enqueueError(106, -100, 1, 13);
                        break;
                    }
                    default: {
                        this.iState = 2;
                        break;
                    }
                }
                break block12;
            }
            this.log.info("EnqueueError: Errors are being suppressed");
        }
        this.log.debug("onDeviceError end.iState:" + this.iState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceStatusUpdate(int nStatusCode) {
        this.log.debug("onDeviceStatus start: " + nStatusCode);
        if (!this.bFreezeEvents) {
            ScannerEventDispatcher scannerEventDispatcher = this.eventDispatcher;
            synchronized (scannerEventDispatcher) {
                StatusUpdateEvent event = new StatusUpdateEvent((Object)this, nStatusCode);
                ScannerEventEntity entity = new ScannerEventEntity((JposEvent)event, ScannerEventEntity.EventType.StatusUpdate);
                this.eventDispatcher.push(entity);
            }
        }
        this.log.debug("onDeviceStatus end.");
    }
}

