/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.service;

import com.xl.jpos.service.DeviceErrorStatusListener;
import com.xl.jpos.service.DirectIODataListener;
import com.xl.jpos.service.XLDevice;
import com.xl.jpos.service.XLDeviceInfo;
import com.xl.jpos.service.XLException;
import com.xl.jpos.service.XLJposConst;
import com.xl.util.DefaultProperties;
import com.xl.util.Logger;
import com.xl.util.XLProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import jpos.JposConst;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DirectIOEvent;
import jpos.loader.JposServiceLoader;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public class XLBaseService
implements BaseService,
JposConst,
DeviceErrorStatusListener,
DirectIODataListener,
XLJposConst {
    protected Logger log = new Logger("XLBaseService");
    protected XLProperties options = null;
    protected int iState = 1;
    protected boolean bOpened = false;
    protected boolean bClaimed = false;
    public boolean bEnabled = false;
    protected boolean bFreezeEvents = false;
    protected String strCheckHealthText = "";
    protected boolean bDeviceOwner = false;
    protected boolean bCapCompareFirmwareVersion = false;
    protected boolean bCapUpdateFirmware = false;
    protected boolean bCapStatisticsReporting = false;
    protected boolean bCapUpdateStatistics = false;
    protected static int iCapPowerReporting = 0;
    protected int iPowerNotify = 0;
    protected static int iPowerState = 2000;
    protected String logicalName = null;
    protected JposEntry jpe = null;
    protected EventCallbacks evtCallback = null;
    protected XLDeviceInfo deviceInfo = null;
    protected XLDevice device = null;
    String category = "Scanner";
    protected boolean notRun = true;
    public int numBytes = 0;
    boolean busyFlag = false;
    protected String manufacturerName;
    protected String physicalDeviceDescription = null;
    protected String physicalDeviceName = null;
    protected String strServiceDesc = "UnifiedPOS Compatible Serial(USB convert Serial) Scanner Service Driver, 2020 XuLong Technologies Corp. All rights reserved. ";
    protected static final int ServiceVer = 1013001;
    private static final String ServiceVersion;

    static {
        String s = String.valueOf(1013001);
        ServiceVersion = new Integer(s.substring(0, 1)) + "." + new Integer(s.substring(1, 4)) + "." + new Integer(s.substring(5, 7));
        Logger.getInstance().info("XuLong Jpos Service Version: " + ServiceVersion);
    }

    public XLBaseService() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.log.debug("XLBaseService constructor.");
    }

    public String getCheckHealthText() throws JposException {
        if (!this.bOpened) {
            this.log.error("getCheckHealthText: (101) Service not open");
        }
        this.log.debug("getCheckHealthText: " + this.strCheckHealthText);
        return this.strCheckHealthText;
    }

    public boolean getClaimed() throws JposException {
        if (!this.bOpened) {
            this.log.error("getClaimed: (101) Service not open");
        }
        this.log.debug("getClaimed: " + this.bClaimed);
        return this.bClaimed;
    }

    public String getDeviceServiceDescription() throws JposException {
        if (!this.bOpened) {
            this.log.error("getDeviceServiceDescription: (101) Service not open");
        }
        this.log.debug("getDeviceServiceDescription: " + this.strServiceDesc);
        return this.strServiceDesc;
    }

    public int getDeviceServiceVersion() throws JposException {
        if (!this.bOpened) {
            this.log.error("getDeviceServiceVersion: (101) Service not open");
        }
        this.log.debug("getDeviceServiceVersion: 1013001");
        return 1013001;
    }

    public String getPhysicalDeviceDescription() throws JposException {
        if (!this.bOpened) {
            this.log.error("getPhysicalDeviceDescription:(101) Service not open");
        }
        String str = this.physicalDeviceDescription;
        if (this.device != null) {
            str = this.device.getDeviceInfo().getProductDescription();
        }
        this.log.debug("getPhysicalDeviceDescription: " + str);
        return str;
    }

    public String getPhysicalDeviceName() throws JposException {
        if (!this.bOpened) {
            this.log.error("getPhysicalDeviceName: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        String str = this.physicalDeviceName;
        if (this.device != null) {
            str = this.device.getDeviceInfo().getProductName();
        }
        this.log.debug("getPhysicalDeviceName: " + str);
        return str;
    }

    public boolean getDeviceEnabled() throws JposException {
        if (!this.bOpened) {
            this.log.error("getDeviceEnabled: (101) Service not open");
        }
        this.log.debug("getDeviceEnabled: " + this.bEnabled);
        return this.bEnabled;
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (!this.bOpened) {
            this.log.error("setDeviceEnabled: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        if (!this.bClaimed) {
            this.log.error("setDeviceEnabled: (103) Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.bEnabled = deviceEnabled;
    }

    public boolean getFreezeEvents() throws JposException {
        if (!this.bOpened) {
            this.log.error("getFreezeEvents: (101) Service not open");
        }
        this.log.debug("getFreezeEvents: " + this.bFreezeEvents);
        return this.bFreezeEvents;
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        if (!this.bOpened) {
            this.log.error("setFreezeEvents: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        this.bFreezeEvents = freezeEvents;
    }

    public int getState() throws JposException {
        return this.iState;
    }

    public void checkHealth(int level) throws JposException {
        this.log.debug("checkHealth start: " + level);
        if (!this.bOpened) {
            this.log.error("checkHealth: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        if (!this.bClaimed) {
            this.log.error("checkHealth: (103) Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        if (!this.bEnabled) {
            this.log.error("checkHealth: (105) Device not enabled");
            throw new JposException(105, "Device not enabled");
        }
        switch (level) {
            case 1: {
                try {
                    if (this.device.isAlive()) {
                        this.strCheckHealthText = "Internal HCheck: Successful";
                        break;
                    }
                    this.strCheckHealthText = "Internal HCheck: Not Successful";
                    break;
                }
                catch (XLException e) {
                    this.strCheckHealthText = "Internal HCheck: Not Successful: " + e.getMessage();
                }
            }
        }
        this.log.error("checkHealth: (106) Device only supports internal health checks");
        this.strCheckHealthText = "Device only supports internal health checks";
        this.log.debug("checkHealth end.");
    }

    public void open(String logicalName, EventCallbacks cb) throws JposException {
        this.log.debug("BaseService open start: " + logicalName);
        if (this.bOpened) {
            this.log.error("BaseService open error:(106) Service is already open");
            throw new JposException(106, "Service is already open");
        }
        this.jpe = JposServiceLoader.getManager().getEntryRegistry().getJposEntry(logicalName);
        if (this.jpe == null) {
            this.log.error("BaseService open error:(109) Logical device could not be found");
            throw new JposException(109, "Logical device could not be found");
        }
        this.logicalName = logicalName;
        this.evtCallback = cb;
        this.deviceInfo = new XLDeviceInfo();
        this.deviceInfo.loadConfiguration(logicalName);
        this.options = DefaultProperties.getInstance();
        this.physicalDeviceName = this.deviceInfo.getProductName();
        this.physicalDeviceDescription = this.deviceInfo.getProductDescription();
        this.strCheckHealthText = "";
        this.bCapCompareFirmwareVersion = false;
        this.bCapUpdateFirmware = false;
        this.bCapStatisticsReporting = false;
        this.bCapUpdateStatistics = false;
        this.bOpened = true;
        this.iState = 2;
        this.log.debug("BaseService  open end.");
    }

    public void claim(int timeout) throws JposException {
        this.log.debug("BaseService claim start.");
        if (!this.bOpened) {
            this.log.error("claim: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        if (this.bClaimed) {
            this.log.error("claim: (102) Device is already claimed.");
            throw new JposException(102, "Device is already claimed.");
        }
        try {
            this.device = XLDevice.createDevice(this.deviceInfo);
            this.device.claim(timeout);
            this.device.addDeviceErrorListener(this);
            this.device.addDeviceStatusListener(this);
            this.device.addDirectIODataListener(this);
        }
        catch (XLException e) {
            this.log.error("claim: (111) " + e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.bClaimed = true;
        this.log.debug("BaseService claim end.");
    }

    public void release() throws JposException {
        this.log.debug("release start.");
        if (!this.bOpened) {
            this.log.error("release: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        if (!this.bClaimed) {
            this.log.error("release:(103) Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        if (this.bEnabled) {
            this.setDeviceEnabled(false);
        }
        try {
            this.device.removeDirectIODataListener(this);
            this.device.removeDeviceErrorListener(this);
            this.device.release();
        }
        catch (XLException e) {
            this.log.error("release: " + e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.bOpened = false;
        this.bClaimed = false;
        this.notRun = true;
        this.log.debug("release end.");
    }

    public void close() throws JposException {
        try {
            if (this.bClaimed) {
                this.release();
            }
            this.iState = 1;
        }
        catch (JposException e) {
            this.log.error(e.getMessage());
        }
        this.log.debug("close.");
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        this.log.debug("directIO start: " + command);
        if (!this.bOpened) {
            this.log.error("directIO: (101) Service not open");
            throw new JposException(101, "Service not open");
        }
        if (!this.getClaimed()) {
            this.log.error("directIO: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.device.directIO(command, data, object);
        }
        catch (XLException e) {
            this.log.error("directIO: " + e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.log.debug("directIO");
    }

    protected void sendDataEvent() {
        this.log.trace("In sendDataEvent - should not be here");
    }

    @Override
    public void onDeviceError(int nErrorCode) {
        this.log.trace("In onDeviceError: " + nErrorCode);
    }

    @Override
    public void onDeviceStatusUpdate(int nStatusCode) {
        this.log.trace("In onDeviceStatus" + nStatusCode);
    }

    @Override
    public void onDirectIOData(int cmd, byte[] buf) {
        this.log.debug("onDirectIOData, cmd=" + cmd);
        try {
            if (buf != null && buf.length != 0) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                bs.write(buf);
                this.evtCallback.fireDirectIOEvent(new DirectIOEvent((Object)this, cmd, 0, (Object)bs));
            } else {
                this.log.error("buf size is zero/null");
            }
        }
        catch (IOException ioe) {
            this.log.error("Error writing to byte array output stream." + ioe.getMessage().toString());
        }
        this.log.debug("onDirectIOData");
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (XLBaseService.this.getState() != 1) {
                    if (XLBaseService.this.getDeviceEnabled()) {
                        XLBaseService.this.setDeviceEnabled(false);
                    }
                    if (XLBaseService.this.getClaimed()) {
                        XLBaseService.this.release();
                    }
                    XLBaseService.this.close();
                }
            }
            catch (JposException ex) {
                System.err.println("ShutdownHook Error:(" + ex.getErrorCode() + ") " + ex.getMessage() + "\r\n\tStackTrace:" + ex.getStackTrace());
            }
        }
    }
}

