/*
 * Decompiled with CFR 0.152.
 */
package com.xl.jpos.service;

import com.xl.util.Logger;
import java.util.Hashtable;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.simple.SimpleEntry;
import jpos.loader.JposServiceLoader;

public abstract class JPosConfigSettings {
    protected Logger log = new Logger("AppEnvironment");
    String[][] strConfigArray;
    private String strLogicalName;
    public Hashtable<String, String> mapConfig = new Hashtable();

    protected abstract String[][] getConfigArray();

    public boolean loadConfiguration(String strLogicalName) {
        this.log.debug("loadConfiguration start with logicalName: " + strLogicalName);
        this.strConfigArray = this.getConfigArray();
        boolean bRc = true;
        this.strLogicalName = strLogicalName;
        int i = 0;
        while (i < this.strConfigArray.length) {
            ++i;
        }
        JposEntryRegistry registry = JposServiceLoader.getManager().getEntryRegistry();
        JposEntry entry = registry.getJposEntry(strLogicalName);
        if (entry == null) {
            this.log.error("loadConfiguration Error loading configuration for: " + strLogicalName);
            bRc = false;
            return bRc;
        }
        int i2 = 0;
        while (i2 < this.strConfigArray.length) {
            this.strConfigArray[i2][1] = this.readOption(entry, this.strConfigArray[i2][0], this.strConfigArray[i2][1]);
            ++i2;
        }
        this.mapConfig.clear();
        i2 = 0;
        while (i2 < this.strConfigArray.length) {
            this.mapConfig.put(this.strConfigArray[i2][0], this.strConfigArray[i2][1]);
            ++i2;
        }
        this.log.debug("loadConfiguration end successful.");
        return bRc;
    }

    public boolean saveConfiguration() {
        this.log.debug("saveConfiguration: " + this.strLogicalName);
        if (this.strLogicalName == null) {
            this.log.debug("saveConfiguration end with logical name is null");
            return false;
        }
        try {
            JposEntryRegistry registry = JposServiceLoader.getManager().getEntryRegistry();
            registry.load();
            JposEntry entry = registry.getJposEntry(this.strLogicalName);
            if (entry == null) {
                entry = new SimpleEntry();
                entry.addProperty("logicalName", (Object)this.strLogicalName);
                registry.addJposEntry(entry);
            }
            this.saveConfiguration(entry);
            registry.save();
        }
        catch (Exception e) {
            this.log.error("saveConfiguration Error saving configuration: " + this.strLogicalName + "," + e.getMessage());
            return false;
        }
        this.log.debug("saveConfiguration end successful.");
        return true;
    }

    public boolean saveConfiguration(JposEntry entry) {
        this.log.debug("saveConfiguration for entry with LogicalName:" + entry.getLogicalName());
        try {
            if (entry != null) {
                for (String element : this.mapConfig.keySet()) {
                    if (entry.hasPropertyWithName(element)) {
                        entry.modifyPropertyValue(element, (Object)this.mapConfig.get(element));
                        continue;
                    }
                    entry.addProperty(element, (Object)this.mapConfig.get(element));
                }
            }
        }
        catch (Exception e) {
            this.log.error("saveConfiguration Error saving configuration: " + this.strLogicalName + "," + e.getMessage());
            return false;
        }
        this.log.debug("saveConfiguration ended successful.");
        return true;
    }

    public String getLogicalName() {
        return this.strLogicalName;
    }

    protected String readOption(JposEntry entry, String strOption, String strDefault) {
        String strRetValue = strDefault;
        String strValue = null;
        try {
            strValue = (String)entry.getPropertyValue(strOption);
        }
        catch (ClassCastException cce) {
            try {
                strValue = ((Integer)entry.getPropertyValue(strOption)).toString();
            }
            catch (ClassCastException cce2) {
                try {
                    Boolean b = (Boolean)entry.getPropertyValue(strOption);
                    strValue = b.booleanValue() ? "1" : "0";
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        if (strValue != null) {
            strRetValue = strValue;
        }
        return strRetValue;
    }

    public boolean getOptionAsBoolean(String strOption) {
        String strValue = this.getOption(strOption).toUpperCase().trim();
        return strValue.equals("true") || strValue.equals("1");
    }

    public int getOptionAsInt(String strOption) {
        String strValue = this.getOption(strOption);
        int nRet = 0;
        try {
            nRet = Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            this.log.error("getOptionAsInt Error converting int: " + strOption + ":" + strValue);
        }
        return nRet;
    }

    public int getOptionAsIntHex(String strOption) {
        String strValue = this.getOption(strOption);
        int nRet = 0;
        try {
            nRet = Integer.parseInt(strValue, 16);
        }
        catch (NumberFormatException nfe) {
            this.log.error("getOptionAsIntHex Error converting int: " + strOption + ":" + strValue);
        }
        return nRet;
    }

    public String getOption(String strOption) {
        String strValue = "";
        try {
            strValue = this.mapConfig.get(strOption);
        }
        catch (NullPointerException npe) {
            this.log.error("getOption Error getOption: " + strOption + ": null");
        }
        return strValue;
    }

    public void setOption(String strOption, boolean bValue) {
        if (bValue) {
            this.setOption(strOption, "True");
        } else {
            this.setOption(strOption, "False");
        }
    }

    public void setOption(String strOption, int nValue) {
        this.setOption(strOption, Integer.toString(nValue));
    }

    public void setOption(String strOption, String strValue) {
        String put = this.mapConfig.put(strOption, strValue);
    }
}

